/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.textures.UnitSprite;

public class StandaloneModelConfiguration
implements IModelConfiguration {
    public static final ResourceLocation LOCATION = new ResourceLocation("forge", "standalone");
    public static final StandaloneModelConfiguration INSTANCE = new StandaloneModelConfiguration(LOCATION, Map.of());
    private final Map<String, ResourceLocation> textures;

    public static StandaloneModelConfiguration create(ResourceLocation modelName) {
        return new StandaloneModelConfiguration(modelName, Map.of());
    }

    public static StandaloneModelConfiguration create(Map<String, ResourceLocation> textures) {
        return new StandaloneModelConfiguration(LOCATION, textures);
    }

    public static StandaloneModelConfiguration create(ResourceLocation modelName, Map<String, ResourceLocation> textures) {
        return new StandaloneModelConfiguration(modelName, textures);
    }

    public StandaloneModelConfiguration(ResourceLocation modelName, Map<String, ResourceLocation> textures) {
        this.textures = textures;
    }

    @Override
    @Nullable
    public UnbakedModel getOwnerModel() {
        return null;
    }

    @Override
    public String getModelName() {
        return LOCATION.toString();
    }

    @Override
    public boolean isTexturePresent(String name) {
        return this.textures.containsKey(name);
    }

    @Override
    public Material resolveTexture(String name) {
        return new Material(UnitSprite.LOCATION, this.textures.getOrDefault(name, UnitSprite.LOCATION));
    }

    @Override
    public boolean isShadedInGui() {
        return true;
    }

    @Override
    public boolean isSideLit() {
        return true;
    }

    @Override
    public boolean useSmoothLighting() {
        return true;
    }

    @Override
    public ItemTransforms getCameraTransforms() {
        return ItemTransforms.f_111786_;
    }

    @Override
    public ModelState getCombinedTransform() {
        return BlockModelRotation.X0_Y0;
    }
}

